/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.impl.BackgroundComponent;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.overlays.ProcessingOverlay;
import pro.gravit.launcher.gui.overlays.UploadAssetOverlay;
import pro.gravit.launcher.gui.overlays.WelcomeOverlay;
import pro.gravit.launcher.gui.scenes.console.ConsoleScene;
import pro.gravit.launcher.gui.scenes.debug.DebugScene;
import pro.gravit.launcher.gui.scenes.internal.BrowserScene;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.gui.scenes.settings.GlobalSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.gui.scenes.update.UpdateScene;
import pro.gravit.launcher.gui.stage.ConsoleStage;
import pro.gravit.utils.helper.LogHelper;

public class GuiObjectsContainer {
    private final JavaFXApplication application;
    private final Map<String, AbstractVisualComponent> components = new HashMap<String, AbstractVisualComponent>();
    public ProcessingOverlay processingOverlay;
    public WelcomeOverlay welcomeOverlay;
    public UploadAssetOverlay uploadAssetOverlay;
    public UpdateScene updateScene;
    public DebugScene debugScene;
    public ServerMenuScene serverMenuScene;
    public ServerInfoScene serverInfoScene;
    public LoginScene loginScene;
    public OptionsScene optionsScene;
    public SettingsScene settingsScene;
    public GlobalSettingsScene globalSettingsScene;
    public ConsoleScene consoleScene;
    public ConsoleStage consoleStage;
    public BrowserScene browserScene;
    public BackgroundComponent background;

    public GuiObjectsContainer(JavaFXApplication application) {
        this.application = application;
    }

    public void init() {
        this.background = this.registerComponent(BackgroundComponent.class);
        this.loginScene = this.registerComponent(LoginScene.class);
        this.processingOverlay = this.registerComponent(ProcessingOverlay.class);
        this.welcomeOverlay = this.registerComponent(WelcomeOverlay.class);
        this.uploadAssetOverlay = this.registerComponent(UploadAssetOverlay.class);
        this.serverMenuScene = this.registerComponent(ServerMenuScene.class);
        this.serverInfoScene = this.registerComponent(ServerInfoScene.class);
        this.optionsScene = this.registerComponent(OptionsScene.class);
        this.settingsScene = this.registerComponent(SettingsScene.class);
        this.globalSettingsScene = this.registerComponent(GlobalSettingsScene.class);
        this.consoleScene = this.registerComponent(ConsoleScene.class);
        this.updateScene = this.registerComponent(UpdateScene.class);
        this.debugScene = this.registerComponent(DebugScene.class);
        this.browserScene = this.registerComponent(BrowserScene.class);
    }

    public Collection<AbstractVisualComponent> getComponents() {
        return this.components.values();
    }

    public void reload() throws Exception {
        String sceneName = this.application.getCurrentScene().getName();
        ContextHelper.runInFxThreadStatic(() -> {
            this.application.getMainStage().setScene(null, false);
            this.application.getMainStage().pullBackground(this.background);
            this.application.resetDirectory();
            this.components.clear();
            this.application.getMainStage().resetStyles();
            this.init();
            this.application.getMainStage().pushBackground(this.background);
            for (AbstractVisualComponent s : this.components.values()) {
                if (!sceneName.equals(s.getName())) continue;
                this.application.getMainStage().setScene(s, false);
            }
        }).get();
    }

    public AbstractVisualComponent getByName(String name) {
        return this.components.get(name);
    }

    public <T extends AbstractVisualComponent> T registerComponent(Class<T> clazz) {
        try {
            AbstractVisualComponent instance = (AbstractVisualComponent)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this.application});
            this.components.put(instance.getName(), instance);
            return (T)instance;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

